/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.awt.Color;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.autoplot.ApplicationModel;
import org.autoplot.MouseModuleType;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.Options;
import org.das2.graph.DasColorBar;
import org.das2.util.LoggerManager;
import org.fuin.utils4j.PropertiesFilePreferences;

public final class OptionsPrefsController {
    Preferences prefs;
    Options options;
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.dom");
    private boolean loadPersistentPreferences;
    public static final String PROP_LOADPERSISTENTPREFERENCES = "loadPersistentPreferences";

    public void copyOptionsToPersistentPreferences() {
        logger.fine("copy options to persistent preferences storage.");
        this.prefs.put("background", DomUtil.encodeColor(this.options.getBackground()));
        this.prefs.put("foreground", DomUtil.encodeColor(this.options.getForeground()));
        this.prefs.put("color", DomUtil.encodeColor(this.options.getColor()));
        this.prefs.put("fillColor", DomUtil.encodeColor(this.options.getFillColor()));
        this.prefs.put("colortable", this.options.getColortable().getListLabel());
        this.prefs.put("canvasFont", this.options.getCanvasFont());
        this.prefs.putInt("width", this.options.getWidth());
        this.prefs.putInt("height", this.options.getHeight());
        this.prefs.put("lineThickness", this.options.getLineThickness());
        this.prefs.putBoolean("flipColorbarLabel", this.options.isFlipColorbarLabel());
        this.prefs.putBoolean("drawGrid", this.options.isDrawGrid());
        this.prefs.putBoolean("drawMinorGrid", this.options.isDrawMinorGrid());
        this.prefs.putBoolean("overRendering", this.options.isOverRendering());
        this.prefs.putBoolean("scriptVisible", this.options.isScriptVisible());
        this.prefs.putBoolean("logConsoleVisible", this.options.isLogConsoleVisible());
        this.prefs.putBoolean("dataVisible", this.options.isDataVisible());
        this.prefs.putBoolean("layoutVisible", this.options.isLayoutVisible());
        this.prefs.putBoolean("specialEffects", this.options.isSpecialEffects());
        this.prefs.putBoolean("textAntiAlias", this.options.isTextAntiAlias());
        this.prefs.putBoolean("dayOfYear", this.options.isDayOfYear());
        this.prefs.putBoolean("nearestNeighbor", this.options.isNearestNeighbor());
        try {
            this.prefs.put("mouseModule", this.options.mouseModule.toString());
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        this.prefs.putBoolean("flipColorbarLabel", this.options.isFlipColorbarLabel());
        this.prefs.put("ticklen", this.options.getTicklen());
        this.prefs.putBoolean("oppositeAxisVisible", this.options.isOppositeAxisVisible());
        this.prefs.put("lineThickness", this.options.getLineThickness());
        this.prefs.putFloat("multiLineTextAlignment", this.options.getMultiLineTextAlignment());
        this.prefs.put("printingTag", this.options.getPrintingTag());
        this.prefs.put("printingLogLevel", this.options.getPrintingLogLevel().toString());
        this.prefs.put("displayLogLevel", this.options.getDisplayLogLevel().toString());
        this.prefs.putInt("logMessageTimeoutSec", this.options.getLogMessageTimeoutSec());
        try {
            this.prefs.flush();
        }
        catch (BackingStoreException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    public OptionsPrefsController(ApplicationModel model, Options options) {
        String f = AutoplotSettings.settings().resolveProperty("autoplotData");
        File config = new File(f, "config");
        this.prefs = new PropertiesFilePreferences(config, "options.properties");
        this.options = options;
        this.loadPersistentPreferences = !model.isHeadless();
        options.setController(this);
    }

    public boolean isLoadPersistentPreferences() {
        return this.loadPersistentPreferences;
    }

    public void setLoadPersistentPreferences(boolean loadPersistentPreferences) {
        this.loadPersistentPreferences = loadPersistentPreferences;
    }

    public void loadPreferencesWithEvents() {
        if (!this.loadPersistentPreferences) {
            logger.fine("persistent preferences are disabled");
            return;
        }
        logger.fine("loading preferences into dom.options (and firing events).");
        this.options.setAutolabelling(this.prefs.getBoolean("autolabelling", this.options.autolabelling));
        this.options.setAutolayout(this.prefs.getBoolean("autolayout", this.options.autolayout));
        this.options.setAutoranging(this.prefs.getBoolean("autoranging", this.options.autoranging));
        if (!this.options.autoranging) {
            System.err.println("Autorange default was false, enabling it now.");
            this.options.setAutoranging(true);
        }
        if (!this.options.autolayout) {
            System.err.println("Autolayout default was false, enabling it now.");
            this.options.setAutolayout(true);
        }
        if (!this.options.autolabelling) {
            System.err.println("Autolabelling default was false, enabling it now.");
            this.options.setAutolabelling(true);
        }
        this.options.setBackground(Color.decode(this.prefs.get("background", DomUtil.encodeColor(this.options.background))));
        this.options.setCanvasFont(this.prefs.get("canvasFont", this.options.canvasFont));
        this.options.setWidth(this.prefs.getInt("width", this.options.getWidth()));
        this.options.setHeight(this.prefs.getInt("height", this.options.getHeight()));
        this.options.setColor(Color.decode(this.prefs.get("color", DomUtil.encodeColor(this.options.color))));
        this.options.setDrawAntiAlias(this.prefs.getBoolean("drawAntiAlias", this.options.drawAntiAlias));
        this.options.setDrawGrid(this.prefs.getBoolean("drawGrid", this.options.drawGrid));
        this.options.setDrawMinorGrid(this.prefs.getBoolean("drawMinorGrid", this.options.drawMinorGrid));
        this.options.setFillColor(Color.decode(this.prefs.get("fillColor", DomUtil.encodeColor(this.options.fillColor))));
        this.options.setColortable(DasColorBar.Type.parse((String)this.prefs.get("colortable", this.options.colortable.getListLabel())));
        this.options.setForeground(Color.decode(this.prefs.get("foreground", DomUtil.encodeColor(this.options.foreground))));
        this.options.setLogConsoleVisible(this.prefs.getBoolean("logConsoleVisible", this.options.logConsoleVisible));
        this.options.setOverRendering(this.prefs.getBoolean("overRendering", this.options.overRendering));
        this.options.setScriptVisible(this.prefs.getBoolean("scriptVisible", this.options.scriptVisible));
        this.options.setDataVisible(this.prefs.getBoolean("dataVisible", this.options.dataVisible));
        this.options.setLayoutVisible(this.prefs.getBoolean("layoutVisible", this.options.layoutVisible));
        this.options.setServerEnabled(this.prefs.getBoolean("serverEnabled", this.options.serverEnabled));
        this.options.setSpecialEffects(this.prefs.getBoolean("specialEffects", this.options.specialEffects));
        this.options.setTextAntiAlias(this.prefs.getBoolean("textAntiAlias", this.options.textAntiAlias));
        this.options.setDayOfYear(this.prefs.getBoolean("dayOfYear", this.options.dayOfYear));
        this.options.setNearestNeighbor(this.prefs.getBoolean("nearestNeighbor", this.options.nearestNeighbor));
        try {
            this.options.setMouseModule(MouseModuleType.valueOf(this.prefs.get("mouseModule", this.options.mouseModule.toString())));
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        this.options.setFlipColorbarLabel(this.prefs.getBoolean("flipColorbarLabel", this.options.flipColorbarLabel));
        this.options.setTicklen(this.prefs.get("ticklen", this.options.ticklen));
        this.options.setOppositeAxisVisible(this.prefs.getBoolean("oppositeAxisVisible", this.options.isOppositeAxisVisible()));
        this.options.setLineThickness(this.prefs.get("lineThickness", this.options.lineThickness));
        this.options.setMultiLineTextAlignment(this.prefs.getFloat("multiLineTextAlignment", this.options.multiLineTextAlignment));
        this.options.setPrintingTag(this.prefs.get("printingTag", this.options.printingTag));
        this.options.setPrintingLogLevel(Level.parse(this.prefs.get("printingLogLevel", this.options.printingLogLevel.toString())));
        this.options.setDisplayLogLevel(Level.parse(this.prefs.get("displayLogLevel", this.options.displayLogLevel.toString())));
        this.options.setLogMessageTimeoutSec(this.prefs.getInt("logMessageTimeoutSec", this.options.logMessageTimeoutSec));
    }

    public void loadPreferences() {
        if (!this.loadPersistentPreferences) {
            logger.fine("persistent preferences are disabled");
            return;
        }
        logger.fine("loading preferences into dom.options");
        this.options.autolabelling = this.prefs.getBoolean("autolabelling", this.options.autolabelling);
        this.options.autolayout = this.prefs.getBoolean("autolayout", this.options.autolayout);
        this.options.autoranging = this.prefs.getBoolean("autoranging", this.options.autoranging);
        if (!this.options.autoranging) {
            System.err.println("Autorange default was false, enabling it now.");
            this.options.autoranging = true;
        }
        if (!this.options.autolayout) {
            System.err.println("Autolayout default was false, enabling it now.");
            this.options.autolayout = true;
        }
        if (!this.options.autolabelling) {
            System.err.println("Autolabelling default was false, enabling it now.");
            this.options.autolabelling = true;
        }
        this.options.background = Color.decode(this.prefs.get("background", DomUtil.encodeColor(this.options.background)));
        this.options.canvasFont = this.prefs.get("canvasFont", this.options.canvasFont);
        this.options.width = this.prefs.getInt("width", this.options.getWidth());
        this.options.height = this.prefs.getInt("height", this.options.getHeight());
        this.options.color = Color.decode(this.prefs.get("color", DomUtil.encodeColor(this.options.color)));
        this.options.drawAntiAlias = this.prefs.getBoolean("drawAntiAlias", this.options.drawAntiAlias);
        this.options.drawGrid = this.prefs.getBoolean("drawGrid", this.options.drawGrid);
        this.options.drawMinorGrid = this.prefs.getBoolean("drawMinorGrid", this.options.drawMinorGrid);
        this.options.fillColor = Color.decode(this.prefs.get("fillColor", DomUtil.encodeColor(this.options.fillColor)));
        this.options.colortable = DasColorBar.Type.parse((String)this.prefs.get("colortable", this.options.colortable.getListLabel()));
        this.options.foreground = Color.decode(this.prefs.get("foreground", DomUtil.encodeColor(this.options.foreground)));
        this.options.logConsoleVisible = this.prefs.getBoolean("logConsoleVisible", this.options.logConsoleVisible);
        this.options.overRendering = this.prefs.getBoolean("overRendering", this.options.overRendering);
        this.options.scriptVisible = this.prefs.getBoolean("scriptVisible", this.options.scriptVisible);
        this.options.dataVisible = this.prefs.getBoolean("dataVisible", this.options.dataVisible);
        this.options.layoutVisible = this.prefs.getBoolean("layoutVisible", this.options.layoutVisible);
        this.options.serverEnabled = this.prefs.getBoolean("serverEnabled", this.options.serverEnabled);
        this.options.specialEffects = this.prefs.getBoolean("specialEffects", this.options.specialEffects);
        this.options.textAntiAlias = this.prefs.getBoolean("textAntiAlias", this.options.textAntiAlias);
        this.options.dayOfYear = this.prefs.getBoolean("dayOfYear", this.options.dayOfYear);
        this.options.nearestNeighbor = this.prefs.getBoolean("nearestNeighbor", this.options.nearestNeighbor);
        try {
            this.options.setMouseModule(MouseModuleType.valueOf(this.prefs.get("mouseModule", this.options.mouseModule.toString())));
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        this.options.flipColorbarLabel = this.prefs.getBoolean("flipColorbarLabel", this.options.flipColorbarLabel);
        this.options.ticklen = this.prefs.get("ticklen", this.options.ticklen);
        this.options.oppositeAxisVisible = this.prefs.getBoolean("oppositeAxisVisible", this.options.oppositeAxisVisible);
        this.options.lineThickness = this.prefs.get("lineThickness", this.options.lineThickness);
        this.options.multiLineTextAlignment = this.prefs.getFloat("multiLineTextAlignment", this.options.multiLineTextAlignment);
        this.options.printingTag = this.prefs.get("printingTag", this.options.printingTag);
        this.options.printingLogLevel = Level.parse(this.prefs.get("printingLogLevel", this.options.printingLogLevel.toString()));
        this.options.displayLogLevel = Level.parse(this.prefs.get("displayLogLevel", this.options.displayLogLevel.toString()));
        this.options.logMessageTimeoutSec = this.prefs.getInt("logMessageTimeoutSec", this.options.logMessageTimeoutSec);
    }
}

